#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AntigenNegativeMessage : BaseTest 
	{

		private BOL.AntigenNegativeMessage _testANM;
		private int _antigenTypeID = 123;
		private string _antigenName = "TestName";
		private string _antibodyName = "Anti-Foo";
		private bool _antigenTested = false;
		private Common.TestResult _antigenTestResult = Common.TestResult.P;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
			this._testANM = new BOL.AntigenNegativeMessage(_antigenTypeID, _antigenName, _antibodyName, _antigenTested, _antigenTestResult);
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.AreEqual(_antigenName, this._testANM.AntigenName, "AntigenName");
			Assert.AreEqual(_antigenTypeID, this._testANM.AntigenTypeId, "AntigenTypeId");
			Assert.AreEqual(_antigenTested, this._testANM.Tested, "Tested");
			Assert.AreEqual(_antigenTestResult,  this._testANM.TestResult, "TestResult");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void AntigenTypeID_Pass()
		{
			int tstValue = new Random().Next(int.MinValue, int.MaxValue);

			BOL.AntigenNegativeMessage testANM = new BOL.AntigenNegativeMessage(tstValue, _antigenName, _antibodyName, _antigenTested, _antigenTestResult);

			Assert.AreEqual(tstValue, testANM.AntigenTypeId);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void AntigenTypeID_Fail()
		{
		}

		[Test]
		public void AntigenName_Pass()
		{
			string tstValue = "".PadRight(10, 'X');

			BOL.AntigenNegativeMessage testANM = new BOL.AntigenNegativeMessage(_antigenTypeID , tstValue, _antibodyName, _antigenTested, _antigenTestResult);

			Assert.AreEqual(tstValue, testANM.AntigenName);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void AntigenName_Fail()
		{
		}

		
		[Test]
		public void AntibodyName_Pass()
		{
			string tstValue = "".PadRight(10, 'X');

			BOL.AntigenNegativeMessage testANM = new BOL.AntigenNegativeMessage(_antigenTypeID , _antigenName , tstValue, _antigenTested, _antigenTestResult);

			Assert.AreEqual(tstValue, testANM.AntibodyName);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void AntibodyName_Fail()
		{
		}

		[Test]
		public void Tested_Pass()
		{
			bool tstValue = true;

			BOL.AntigenNegativeMessage testANM = new BOL.AntigenNegativeMessage(_antigenTypeID, _antigenName, _antibodyName, tstValue, _antigenTestResult);

			Assert.AreEqual(tstValue, testANM.Tested);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void Tested_Fail()
		{
		}

		[Test]
		public void TestResult_Pass()
		{
			Common.TestResult tstValue = Common.TestResult.Unknown;

			BOL.AntigenNegativeMessage testANM = new BOL.AntigenNegativeMessage(_antigenTypeID, _antigenName, _antibodyName, _antigenTested, tstValue);

			Assert.AreEqual(tstValue, testANM.TestResult);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void TestResult_Fail()
		{
		}

	}
}

#endif
